<!DOCTYPE html>
<html>
<head>
    <title>Display MySQL Data Based on Option Selection</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>

<div class="container">
    <h2>Select an option</h2>
    <select id="selectOption" class="form-control">
        <option value="">Select an option</option>
        <option value="1">Option 1</option>
        <option value="2">Option 2</option>
        <option value="3">Option 3</option>
    </select>

    <div id="tableContainer"></div>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
$(document).ready(function(){
    $('#selectOption').change(function(){
        var selectedOption = $(this).val();
        if(selectedOption != "") {
            $.ajax({
                url: 'fetch_data.php',
                type: 'POST',
                data: {option: selectedOption},
                success: function(response) {
                    $('#tableContainer').html(response);
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }
    });
});
</script>

</body>
</html>
